<?php
date_default_timezone_set('Europe/Warsaw');
require_once (DIR_SYSTEM . 'library/inpost_shipping/Libraries/guzzle/vendor/autoload.php');

spl_autoload_register(
    function($class) {
        $file = DIR_SYSTEM . 'library/' . str_replace('\\', '/', $class) . '.php';

        if (is_file($file)) {
            include_once($file);

            return true;
        } else {
            return false;
        }
    }
);

use inpost_shipping\InpostApi;

/**
 * InpostShipping class
 */
class inpostShipping {

    protected $inpostApi;

    public function initialize(array $params = [])
    {
        $this->inpostApi = new InpostApi($params);
    }

    /**
     * @param array $apiParams
     *
     * @return bool
     */
    public function validateApiKeys(array $apiParams): bool
    {
        return $this->inpostApi->validateApiKeys($apiParams);
    }

    /**
     * @return array
     */
    public function getOrganizationDetails(): array
    {
        return $this->inpostApi->getOrganizationDetails();
    }

    /**
     * @return array
     */
    public function getServices(): array
    {
        return $this->inpostApi->getServices();
    }

    /**
     * @return array
     */
    public function getShippingMethods(): array
    {
        return $this->inpostApi->getShippingMethods();
    }

    /**
     * @return array
     */
    public function getGeoWidgetAssets(): array
    {
        return [
            'script' => $this->inpostApi->getGeoWidgetScript(),
            'style' => $this->inpostApi->getGeoWidgetStylesheet(),
        ];
    }

    /**
     * @param $address
     * @param $ocRegistry
     *
     * @return array
     */
    public function getInpostQuotes($address, $ocRegistry): array
    {
        return $this->inpostApi->getQuotes($address, $ocRegistry);
    }

    /**
     * @param $request
     *
     * @return array
     */
    public function transformShippingMethodRequest($request): array
    {
        return $this->inpostApi->transformShippingMethodRequest($request);
    }

    /**
     * @param $request
     *
     * @return array
     */
    public function transformDeliveryServiceRequest($request): array
    {
        return $this->inpostApi->transformDeliveryServiceRequest($request);
    }

    /**
     * @param $request
     * @param $ocRegistry
     *
     * @return string
     */
    public function validateShippingMethodSaveRequest($request, $ocRegistry): string
    {
        return $this->inpostApi->validateShippingMethodSaveRequest($request, $ocRegistry);
    }

    /**
     * @param $request
     * @param $ocRegistry
     *
     * @return array
     */
    public function createShipment($request, $ocRegistry): array
    {
        return $this->inpostApi->createShipment($request, $ocRegistry);
    }

    /**
     * @param array $labelParams
     *
     * @return array
     */
    public function printLabel(array $labelParams): array
    {
        return $this->inpostApi->printLabel($labelParams);
    }

    /**
     * @param string $idShipment
     *
     * @return array
     */
    public function printDispatchLabel(string $idShipment): array
    {
        return $this->inpostApi->printDispatchLabel($idShipment);
    }

    /**
     * @param array $idsShipment
     *
     * @return array
     */
    public function printBulkDispatchLabel(array $idsShipment): array
    {
        return $this->inpostApi->printBulkDispatchLabel($idsShipment);
    }

    /**
     * @param array $request
     * @param $ocRegistry
     *
     * @return array
     */
    public function dispatchOrder(array $request, $ocRegistry): array
    {
        return $this->inpostApi->dispatchOrder($request, $ocRegistry);
    }

    /**
     * @return array
     */
    public function getStatuses(): array
    {
        return $this->inpostApi->getStatuses();
    }

    /**
     * @param array $data
     * @param $ocRegistry
     */
    public function updateShipmentStatus(array $data, $ocRegistry): void
    {
        $this->inpostApi->updateShipmentStatus($data, $ocRegistry);
    }

    /**
     * @param $ocRegistry
     *
     * @return array
     */
    public function syncPickupPoints($ocRegistry): array
    {
        return $this->inpostApi->syncPickupPoints($ocRegistry);
    }

    /**
     * @param string $id
     * @param $ocRegistry
     * @param int $retryCount
     *
     * @return array
     */
    public function syncTrackingNumber(string $id, $ocRegistry, int $retryCount = 1): array
    {
        if ($retryCount < 1) {
            $retryCount = 1;
        }

        return $this->inpostApi->syncTrackingNumber($id, $ocRegistry, $retryCount);
    }

    /**
     * @param int $sbxMode
     * @param $ocRegistry
     *
     * @return array
     */
    public function syncShipmentStatuses(int $sbxMode, $ocRegistry): array
    {
        return $this->inpostApi->syncShipmentStatuses($sbxMode, $ocRegistry);
    }
}