<?php

namespace inpost_shipping;

class InpostConfig
{
    public const TN_REQUEST_RETRY_COUNT = 10;

    public const DISABLED_SERVICES = [
        'inpost_locker_allegro',
        'inpost_courier_allegro',
        'inpost_letter_allegro',
    ];

    /**
     * @var array
     */
    public const SENDING_METHOD_SERVICES = [
        'inpost_locker_standard' => [
            'parcel_locker' => true,
            'dispatch_order' => true,
            'pop' => true,
        ],
        'inpost_locker_pass_thru' => [
            'parcel_locker' => true,
            'dispatch_order' => false,
            'pop' => false,
        ],
        'inpost_courier_standard' => [
            'parcel_locker' => false,
            'dispatch_order' => true,
            'pop' => true,
        ],
        'inpost_courier_express_1000' => [
            'parcel_locker' => false,
            'dispatch_order' => true,
            'pop' => true,
        ],
        'inpost_courier_express_1200' => [
            'parcel_locker' => false,
            'dispatch_order' => true,
            'pop' => true,
        ],
        'inpost_courier_express_1700' => [
            'parcel_locker' => false,
            'dispatch_order' => true,
            'pop' => true,
        ],
        'inpost_locker_allegro' => [
            'parcel_locker' => true,
            'dispatch_order' => true,
            'pop' => true,
        ],
        'inpost_courier_allegro' => [
            'parcel_locker' => true,
            'dispatch_order' => true,
            'pop' => true,
        ],
        'inpost_letter_allegro' => [
            'parcel_locker' => true,
            'dispatch_order' => true,
            'pop' => true,
        ],
        'inpost_courier_local_standard' => [
            'parcel_locker' => false,
            'dispatch_order' => true,
            'pop' => false,
        ],
        'inpost_courier_local_express' => [
            'parcel_locker' => false,
            'dispatch_order' => true,
            'pop' => false,
        ],
        'inpost_courier_local_super_express' => [
            'parcel_locker' => false,
            'dispatch_order' => true,
            'pop' => false,
        ],
        'inpost_courier_c2c' => [
            'parcel_locker' => true,
            'dispatch_order' => true,
            'pop' => true,
        ],
    ];

    /**
     * @var array
     */
    public const DELIVERY_SERVICES_TRANSLATION = [
        'inpost_courier_c2c' => 'Przesyłka kurierska standardowa InPost Kurier Standard C2C',
    ];

    /**
     * @var array
     */
    public const SIZES_LOCKER = [
        'size_a' => [
            'length' => 80,
            'width' => 380,
            'height' => 640,
            'weight' => 25
        ],
        'size_b' => [
            'length' => 190,
            'width' => 380,
            'height' => 640,
            'weight' => 25
        ],
        'size_c' => [
            'length' => 410,
            'width' => 380,
            'height' => 640,
            'weight' => 25
        ],
    ];

    public const SIZES_LOCKER_C2C = [
        'size_a' => [
            'length' => 80,
            'width' => 380,
            'height' => 640,
            'weight' => 25
        ],
        'size_b' => [
            'length' => 190,
            'width' => 380,
            'height' => 640,
            'weight' => 25
        ],
        'size_c' => [
            'length' => 410,
            'width' => 380,
            'height' => 640,
            'weight' => 25
        ],
        'size_d' => [
            'length' => 500,
            'width' => 500,
            'height' => 800,
            'weight' => 25
        ],
    ];

    public const TEMPLATE_TRANSFORM = [
        'size_a' => 'small',
        'size_b' => 'medium',
        'size_c' => 'large',
        'size_d' => 'xlarge',
    ];
}