<?php

namespace inpost_shipping;

use GuzzleHttp\Client;
use inpost_shipping\Model\Expander\InpostDeliveryServiceExpander;
use inpost_shipping\Model\Expander\InpostShippingMethodExpander;
use inpost_shipping\Model\Points\InpostPickupPoints;
use inpost_shipping\Model\Quote\QuoteHandler;
use inpost_shipping\Model\Shipment\InpostDispatchHandler;
use inpost_shipping\Model\Shipment\InpostShipmentHandler;
use inpost_shipping\Model\Validator\InpostRequestValidator;
use inpost_shipping\Model\Shipment\InpostPrinter;

class InpostFactory
{
    /**
     * @return \inpost_shipping\Model\Expander\InpostShippingMethodExpander
     */
    public function createInpostShippingMethodExpander(): InpostShippingMethodExpander
    {
        return new InpostShippingMethodExpander();
    }

    /**
     * @return \inpost_shipping\Model\Expander\InpostDeliveryServiceExpander
     */
    public function createInpostDeliveryServiceExpander(): InpostDeliveryServiceExpander
    {
        return new InpostDeliveryServiceExpander();
    }

    /**
     * @return \inpost_shipping\Model\Shipment\InpostShipmentHandler
     */
    public function createInpostShipmentHandler(
        Client $guzzleHttp,
        string $idOrganization,
        string $baseUri,
        string $apiKey,
        $ocRegistry
    ): InpostShipmentHandler {
        return new InpostShipmentHandler($guzzleHttp, $idOrganization, $baseUri, $apiKey, $ocRegistry);
    }

    /**
     * @return \inpost_shipping\Model\Validator\InpostRequestValidator
     */
    public function createInpostRequestValidator(): InpostRequestValidator
    {
        return new InpostRequestValidator();
    }

    /**
     * @param \GuzzleHttp\Client $guzzleHttp
     * @param string $idOrganization
     * @param string $baseUri
     * @param string $apiKey
     *
     * @return \inpost_shipping\Model\Shipment\InpostPrinter
     */
    public function createInpostPrinter(
        Client $guzzleHttp,
        string $idOrganization,
        string $baseUri,
        string $apiKey
    ): InpostPrinter {
        return new InpostPrinter($guzzleHttp, $idOrganization, $baseUri, $apiKey);
    }

    /**
     * @param \GuzzleHttp\Client $guzzleHttp
     * @param string $idOrganization
     * @param string $baseUri
     * @param string $apiKey
     * @param $ocRegistry
     *
     * @return \inpost_shipping\Model\Shipment\InpostDispatchHandler
     */
    public function createInpostDispatchHandler(
        Client $guzzleHttp,
        string $idOrganization,
        string $baseUri,
        string $apiKey,
        $ocRegistry
    ): InpostDispatchHandler {
        return new InpostDispatchHandler($guzzleHttp, $idOrganization, $baseUri, $apiKey, $ocRegistry);
    }

    /**
     * @param \GuzzleHttp\Client $guzzleHttp
     * @param string $idOrganization
     * @param string $baseUri
     * @param string $apiKey
     * @param $ocRegistry
     *
     * @return \inpost_shipping\Model\Points\InpostPickupPoints
     */
    public function createInpostPickupPoints(
        Client $guzzleHttp,
        string $idOrganization,
        string $baseUri,
        string $apiKey,
        $ocRegistry
    ): InpostPickupPoints {
        return new InpostPickupPoints($guzzleHttp, $idOrganization, $baseUri, $apiKey, $ocRegistry);
    }

    /**
     * @return \inpost_shipping\Model\Quote\QuoteHandler
     */
    public function createQuoteHandler(): QuoteHandler
    {
        return new QuoteHandler();
    }
}