<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

use InPost\International\Carrier\Grid\CarrierGridDefinitionFactory;
use InPost\International\Carrier\Grid\NewCarriersPageFlagChecker;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\ExpressionLanguage\Expression;

if (!defined('_PS_VERSION_') || Tools::version_compare(_PS_VERSION_, '9.0.0')) {
    return;
}

assert(isset($container) && $container instanceof ContainerBuilder);

$container->register(NewCarriersPageFlagChecker::class)
    ->setAutowired(true);

$container->getDefinition(CarrierGridDefinitionFactory::class)
    ->setBindings([
        '$useLegacyCarriersPage' => new Expression(sprintf('!service("%s").isEnabled()', str_replace('\\', '\\\\', NewCarriersPageFlagChecker::class))),
    ]);
