<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

use Symfony\Bridge\Doctrine\ArgumentResolver\EntityValueResolver;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException;

if (!defined('_PS_VERSION_') || Tools::version_compare(_PS_VERSION_, '9.0.0')) {
    return;
}

assert(isset($container) && $container instanceof ContainerBuilder);

try {
    $container->getDefinition('doctrine.orm.entity_value_resolver');
} catch (ServiceNotFoundException $e) {
    $container->register('doctrine.orm.entity_value_resolver', EntityValueResolver::class)
        ->setAutowired(true)
        ->addTag('controller.argument_value_resolver', ['priority' => 110]);
}
