<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

use InPost\International\Geocoding\GeocoderFactory;
use InPost\International\Geocoding\SpecializedGeocoderFactoryInterface;
use Symfony\Component\DependencyInjection\Argument\ServiceLocatorArgument;
use Symfony\Component\DependencyInjection\Argument\TaggedIteratorArgument;
use Symfony\Component\DependencyInjection\ContainerBuilder;

if (!defined('_PS_VERSION_') || Tools::version_compare(_PS_VERSION_, '8.1.0')) {
    return;
}

assert(isset($container) && $container instanceof ContainerBuilder);

$container
    ->registerForAutoconfiguration(SpecializedGeocoderFactoryInterface::class)
    ->addTag('inpost.intl.geocoding.geocoder_factory');

$container->removeDefinition('inpost.intl.geocoding.factory_locator');
$container
    ->getDefinition(GeocoderFactory::class)
    ->setArgument(1, new ServiceLocatorArgument(new TaggedIteratorArgument('inpost.international.geocoding.geocoder_factory', null, 'getGeocoderTypeId', true)));
