<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

use InPost\International\PrestaShop\ObjectModel\Repository\AbstractServiceObjectRepository;
use InPost\International\PrestaShop\ObjectModel\Repository\ObjectRepositoryFactory;
use Symfony\Component\DependencyInjection\Argument\ServiceLocatorArgument;
use Symfony\Component\DependencyInjection\Argument\TaggedIteratorArgument;
use Symfony\Component\DependencyInjection\ContainerBuilder;

if (!defined('_PS_VERSION_') || Tools::version_compare(_PS_VERSION_, '8.1.0')) {
    return;
}

assert(isset($container) && $container instanceof ContainerBuilder);

$container
    ->registerForAutoconfiguration(AbstractServiceObjectRepository::class)
    ->addTag('inpost.intl.object_model.repository');

$container->removeDefinition('inpost.intl.object_model.repository_locator');
$container->getDefinition(ObjectRepositoryFactory::class)
    ->setArgument(0, new ServiceLocatorArgument(new TaggedIteratorArgument('inpost.intl.object_model.repository', 'model', null, true)));
