<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\Serializer\Mapping\Loader\AttributeLoader;

if (!defined('_PS_VERSION_') || Tools::version_compare(_PS_VERSION_, '9.0.0')) {
    return;
}

assert(isset($container) && $container instanceof ContainerBuilder);

$container->removeDefinition('inpost.intl.event_dispatcher.subscriber_locator');
$container->register('inpost.intl.serializer.mapping.loader', AttributeLoader::class)
    ->setArgument(0, new Reference('inpost.intl.annotations.reader'));
