<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

use Doctrine\Common\Annotations\PsrCachedReader;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

if (!defined('_PS_VERSION_') || Tools::version_compare(_PS_VERSION_, '8.0.0')) {
    return;
}

assert(isset($container) && $container instanceof ContainerBuilder);

$container->removeDefinition('inpost.intl.annotations.cache');
$container->register('inpost.intl.annotations.reader', PsrCachedReader::class)
    ->setArguments([
        new Reference('annotation_reader'),
        new Reference('inpost.intl.annotations.cache_adapter'),
        false,
        new Reference('inpost.intl.annotations.dummy_registry'),
    ]);
