<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

use InPost\International\Asset\Filter\FrontCompatibilityFilter;
use InPost\International\Asset\FrontAssetManager;
use Symfony\Component\DependencyInjection\ContainerBuilder;

if (
    !defined('_PS_VERSION_')
    || !class_exists(FrontCompatibilityFilter::class)
    || FrontCompatibilityFilter::getVersionRange()->contains(_PS_VERSION_)
) {
    return;
}

assert(isset($container) && $container instanceof ContainerBuilder);

$container->removeDefinition(FrontCompatibilityFilter::class);
$container->getDefinition(FrontAssetManager::class)->setArgument(2, null);
