<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

use InPost\International\Checkout\CheckoutInterface;
use InPost\International\Checkout\CheckoutResolver;
use Symfony\Component\DependencyInjection\Argument\ServiceLocatorArgument;
use Symfony\Component\DependencyInjection\Argument\TaggedIteratorArgument;
use Symfony\Component\DependencyInjection\ContainerBuilder;

if (!defined('_PS_VERSION_') || Tools::version_compare(_PS_VERSION_, '8.1.0')) {
    return;
}

assert(isset($container) && $container instanceof ContainerBuilder);

$container
    ->registerForAutoconfiguration(CheckoutInterface::class)
    ->addTag('inpost.intl.checkout')
    ->addTag('container.do_not_inline');

$container->removeDefinition('inpost.intl.checkout.checkout_locator');
$container
    ->getDefinition(CheckoutResolver::class)
    ->setArgument(0, new ServiceLocatorArgument(new TaggedIteratorArgument('inpost.intl.checkout', null, null, true)));
