<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

use InPost\International\Installer\Database\MigrationInterface;
use InPost\International\Installer\InstallerInterface;
use InPost\International\Installer\UninstallerInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

if (!defined('_PS_VERSION_')) {
    return;
}

assert(isset($container) && $container instanceof ContainerBuilder);

$container
    ->registerForAutoconfiguration(InstallerInterface::class)
    ->addTag('inpost.intl.installer');
$container
    ->registerForAutoconfiguration(UninstallerInterface::class)
    ->addTag('inpost.intl.uninstaller');
$container
    ->registerForAutoconfiguration(MigrationInterface::class)
    ->addTag('inpost.intl.db_migration');
