<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

use Doctrine\DBAL\Connection;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use PrestaShop\PrestaShop\Core\Domain\Configuration\ShopConfigurationInterface;
use PrestaShop\PrestaShop\Core\Localization\LocaleInterface;
use PrestaShop\PrestaShop\Core\Localization\Pack\Import\LocalizationPackImporterInterface;
use PrestaShopBundle\Entity\Repository\LangRepository;
use PrestaShopBundle\Translation\Loader\DatabaseTranslationLoader;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\Translation\TranslatorInterface as LegacyTranslatorInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    return;
}

assert(isset($container) && $container instanceof ContainerBuilder);

$services = [
    'database_connection' => Connection::class,
    'doctrine' => ManagerRegistry::class,
    'doctrine.orm.entity_manager' => EntityManagerInterface::class,
    'prestashop.adapter.legacy.configuration' => ShopConfigurationInterface::class,
    'prestashop.core.admin.lang.repository' => LangRepository::class,
    'prestashop.core.localization.locale.context_locale' => LocaleInterface::class,
    'prestashop.core.localization.pack.import.importer' => LocalizationPackImporterInterface::class,
    'prestashop.translation.database_loader' => DatabaseTranslationLoader::class,
];

if (Tools::version_compare(_PS_VERSION_, '8.0.0')) {
    assert(interface_exists(LegacyTranslatorInterface::class));
    $services['translator'] = LegacyTranslatorInterface::class;
} else {
    $services['translator'] = TranslatorInterface::class;
}

$factory = [new Reference('app_container'), 'get'];

foreach ($services as $id => $class) {
    $container
        ->register($id, $class)
        ->setFactory($factory)
        ->setArguments([$id]);

    $container->setAlias($class, $id);
}
