<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api;

use InPost\International\Api\Pickup\PickupsApiClientInterface;
use InPost\International\Api\Point\PointsApiClientInterface;
use InPost\International\Api\Shipment\ShipmentsApiClientInterface;
use InPost\International\Api\Tracking\TrackingApiClientInterface;
use InPost\International\Environment\EnvironmentInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface ApiClientInterface extends PointsApiClientInterface, ShipmentsApiClientInterface, PickupsApiClientInterface, TrackingApiClientInterface
{
    /**
     * To be replaced with {@see \DateTime::RFC3339_EXTENDED} when we drop support for PHP 7.2 (https://bugs.php.net/bug.php?id=75577).
     */
    public const DATE_TIME_FORMAT = 'Y-m-d\TH:i:s.uP';
    public const TIMEZONE = 'UTC';

    public function getEnvironment(): EnvironmentInterface;
}
