<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ApiError
{
    /**
     * @var int
     */
    private $status;

    /**
     * @var string
     */
    private $key;

    /**
     * @var string
     */
    private $error;

    public function __construct(int $status, string $key, string $error)
    {
        $this->key = $key;
        $this->status = $status;
        $this->error = $error;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function getKey(): string
    {
        return $this->key;
    }

    public function getError(): string
    {
        return $this->error;
    }
}
