<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ApiProblem
{
    public const TYPE_BLANK = 'about:blank';

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $type;

    /**
     * @var int|null
     */
    private $status;

    /**
     * @var string|null
     */
    private $detail;

    /**
     * @var string
     */
    private $instance;

    /**
     * @var array<string, mixed>
     */
    private $data = [];

    public function __construct(string $title, string $type = self::TYPE_BLANK, int $status = null, string $detail = null, string $instance = null)
    {
        $this->title = $title;
        $this->type = $type;
        $this->status = $status;
        $this->detail = $detail;
        $this->instance = $instance;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function getDetail(): ?string
    {
        return $this->detail;
    }

    public function getInstance(): ?string
    {
        return $this->instance;
    }

    public function __isset(string $name): bool
    {
        return isset($this->data[$name]);
    }

    /**
     * @return mixed
     */
    public function __get(string $name)
    {
        return $this->data[$name] ?? null;
    }

    /**
     * @param mixed $value
     *
     * @internal
     */
    public function __set(string $name, $value): void
    {
        if (in_array($name, ['title', 'type', 'status', 'detail', 'instance'], true)) {
            throw new \InvalidArgumentException(sprintf('Property "%s" is read-only.', $name));
        }

        $this->data[$name] = $value;
    }
}
