<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Exception;

use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @internal
 */
class ApiException extends \RuntimeException implements ApiExceptionInterface
{
    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @var ResponseInterface
     */
    private $response;

    /**
     * @var int|null
     */
    private $status;

    public function __construct(RequestInterface $request, ResponseInterface $response, string $message, int $status = null, int $code = 0)
    {
        parent::__construct($message, $code);
        $this->request = $request;
        $this->response = $response;
        $this->status = $status;
    }

    public function getRequest(): RequestInterface
    {
        return $this->request;
    }

    public function getResponse(): ResponseInterface
    {
        return $this->response;
    }

    public function getStatusCode(): int
    {
        return $this->status ?? $this->response->getStatusCode();
    }
}
