<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Exception;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @phpstan-type Message array{
 *     field: string|null,
 *     type: string,
 *     data: mixed,
 *     message: string,
 * }
 */
final class PayerNotFoundException extends ApiProblemException
{
    public const PROBLEM_TYPE = 'ILS.PayerNotFoundException';

    /**
     * @return Message[]
     */
    public function getMessages(): array
    {
        return $this->getProblem()->messages ?? [];
    }
}
