<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Exception;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class UnexpectedResponseStatusException extends \UnexpectedValueException implements ApiClientExceptionInterface
{
    public static function create(int $expected, int $actual): self
    {
        return new self(sprintf('Unexpected server response code: %d (expected %d).', $actual, $expected));
    }
}
