<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Exception;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ValidationException extends ApiProblemException
{
    public const PROBLEM_TYPE = 'ValidationException';

    /**
     * @return array<string, string> errors by field name
     */
    public function getErrors(): array
    {
        return $this->getProblem()->errors ?? [];
    }
}
