<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Exception;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ValidationFailedException extends ApiProblemException
{
    public const PROBLEM_TYPE = 'ValidationFailed';

    /**
     * @return array<string, string[]> list of error codes by field name
     */
    public function getErrors(): array
    {
        return $this->getProblem()->errors ?? [];
    }
}
