<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Model;

use InPost\International\Country;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Address
{
    /**
     * @var Country
     */
    private $countryCode;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string
     */
    private $postalCode;

    /**
     * @var string
     */
    private $street;

    /**
     * @var string
     */
    private $houseNumber;

    /**
     * @var string|null
     */
    private $flatNumber;

    /**
     * @var string|null
     */
    private $locationDescription;

    public function __construct(Country $countryCode, string $city, string $postalCode, string $street, string $houseNumber, string $flatNumber = null, string $locationDescription = null)
    {
        $this->countryCode = $countryCode;
        $this->city = $city;
        $this->postalCode = $postalCode;
        $this->street = $street;
        $this->houseNumber = $houseNumber;
        $this->flatNumber = $flatNumber;
        $this->locationDescription = $locationDescription;
    }

    public function getCountryCode(): Country
    {
        return $this->countryCode;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function getPostalCode(): string
    {
        return $this->postalCode;
    }

    public function getStreet(): string
    {
        return $this->street;
    }

    public function getHouseNumber(): string
    {
        return $this->houseNumber;
    }

    public function getFlatNumber(): ?string
    {
        return $this->flatNumber;
    }

    public function getLocationDescription(): ?string
    {
        return $this->locationDescription;
    }
}
