<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Phone
{
    /**
     * @var string
     */
    private $prefix;

    /**
     * @var string
     */
    private $number;

    public function __construct(string $prefix, string $number)
    {
        $this->prefix = $prefix;
        $this->number = $number;
    }

    public function getPrefix(): string
    {
        return $this->prefix;
    }

    public function getNumber(): string
    {
        return $this->number;
    }
}
