<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @implements \IteratorAggregate<string, string>
 */
final class References implements \IteratorAggregate, \JsonSerializable
{
    /**
     * @var string[]
     */
    private $custom;

    /**
     * @param array<string, string> $custom
     */
    public function __construct(array $custom)
    {
        $this->custom = $custom;
    }

    public function getReferences(): array
    {
        return $this->custom;
    }

    public function getIterator(): \ArrayIterator
    {
        return new \ArrayIterator($this->custom);
    }

    /**
     * @return array<string, mixed>
     */
    public function jsonSerialize(): array
    {
        return ['custom' => $this->custom];
    }
}
