<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Volume
{
    /**
     * @var ItemType
     */
    private $itemType;

    /**
     * @var int
     */
    private $count;

    /**
     * @var Weight
     */
    private $totalWeight;

    public function __construct(ItemType $itemType, int $count, Weight $totalWeight)
    {
        $this->itemType = $itemType;
        $this->count = $count;
        $this->totalWeight = $totalWeight;
    }

    public function getItemType(): ItemType
    {
        return $this->itemType;
    }

    public function getCount(): int
    {
        return $this->count;
    }

    public function getTotalWeight(): Weight
    {
        return $this->totalWeight;
    }
}
