<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Model;

use InPost\International\Enum\StringEnum;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method static self Gram()
 * @method static self Decagram()
 * @method static self Kilogram()
 */
final class WeightUnit extends StringEnum
{
    private const GRAM = 'G';
    private const DECAGRAM = 'DAG';
    private const KILOGRAM = 'KG';

    public static function getDefault(): self
    {
        return self::Kilogram();
    }

    public function getSymbol(): string
    {
        return strtolower($this->value);
    }
}
