<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup;

use InPost\International\Api\Exception\ValidationException;
use InPost\International\Api\Pickup\Request\CreatePickupOrderRequest;
use InPost\International\Api\Pickup\Request\CutoffTimeRequest;
use InPost\International\Api\Pickup\Request\PickupOrdersRequest;
use InPost\International\Api\Pickup\Response\CreatePickupOrderResponse;
use InPost\International\Api\Pickup\Response\CutoffTimeResponse;
use InPost\International\Api\Pickup\Response\PickupOrder;
use InPost\International\Api\Pickup\Response\PickupOrderList;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface PickupsApiClientInterface
{
    public const SCOPE_PICKUPS_READ = 'api:one-time-pickups:read';
    public const SCOPE_PICKUPS_WRITE = 'api:one-time-pickups:write';

    public function getPickupOrders(PickupOrdersRequest $request): PickupOrderList;

    public function createPickupOrder(CreatePickupOrderRequest $request): CreatePickupOrderResponse;

    public function getPickupOrder(string $id): PickupOrder;

    /**
     * @throws ValidationException
     */
    public function getCutoffPickupTime(CutoffTimeRequest $request): CutoffTimeResponse;
}
