<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Request;

use InPost\International\Api\Pickup\Model\Address;
use InPost\International\Api\Pickup\Model\ContactPerson;
use InPost\International\Api\Pickup\Model\PickupTime;
use InPost\International\Api\Pickup\Model\References;
use InPost\International\Api\Pickup\Model\Volume;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CreatePickupOrderRequest
{
    /**
     * @var Address
     */
    private $address;

    /**
     * @var ContactPerson
     */
    private $contactPerson;

    /**
     * @var PickupTime
     */
    private $pickupTime;

    /**
     * @var Volume
     */
    private $volume;

    /**
     * @var References|null
     */
    private $references;

    public function __construct(Address $address, ContactPerson $contactPerson, PickupTime $pickupTime, Volume $volume, References $references = null)
    {
        $this->address = $address;
        $this->contactPerson = $contactPerson;
        $this->pickupTime = $pickupTime;
        $this->volume = $volume;
        $this->references = $references;
    }

    public function getAddress(): Address
    {
        return $this->address;
    }

    public function getContactPerson(): ContactPerson
    {
        return $this->contactPerson;
    }

    public function getPickupTime(): PickupTime
    {
        return $this->pickupTime;
    }

    public function getVolume(): Volume
    {
        return $this->volume;
    }

    public function getReferences(): ?References
    {
        return $this->references;
    }
}
