<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Request;

use InPost\International\Country;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CutoffTimeRequest
{
    /**
     * @var Country
     */
    private $countryCode;

    /**
     * @var string
     */
    private $postalCode;

    public function __construct(Country $countryCode, string $postalCode)
    {
        $this->countryCode = $countryCode;
        $this->postalCode = $postalCode;
    }

    public function getCountryCode(): Country
    {
        return $this->countryCode;
    }

    public function getPostalCode(): string
    {
        return $this->postalCode;
    }

    public function toQueryParameters(): array
    {
        return [
            'postalCode' => $this->postalCode,
            'countryCode' => $this->countryCode->value,
        ];
    }
}
