<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PickupOrdersRequest
{
    /**
     * @var int|null
     */
    private $page;

    /**
     * @var int|null
     */
    private $perPage;

    /**
     * @var string[]
     */
    private $sortCriteria;

    /**
     * @param array<string, string> $sortCriteria sort order by property name
     */
    public function __construct(int $page = null, int $perPage = null, array $sortCriteria = [])
    {
        $this->page = $page;
        $this->perPage = $perPage;
        $this->sortCriteria = $sortCriteria;
    }

    public function getPage(): ?int
    {
        return $this->page;
    }

    public function getPerPage(): ?int
    {
        return $this->perPage;
    }

    /**
     * @return array<string, string> sort order by property name
     */
    public function getSortCriteria(): array
    {
        return $this->sortCriteria;
    }

    public function toQueryParameters(): array
    {
        $params = [];

        if (null !== $this->page) {
            $params['page'] = (string) $this->page;
        }

        if (null !== $this->perPage) {
            $params['perPage'] = (string) $this->perPage;
        }

        if ([] !== $this->sortCriteria) {
            foreach ($this->sortCriteria as $property => $order) {
                $params['sort'][] = sprintf('%s,%s', $property, $order);
            }
        }

        return $params;
    }
}
