<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CarrierReference
{
    /**
     * @var string
     */
    private $trackingNumber;

    /**
     * @var string
     */
    private $carrier;

    public function __construct(string $trackingNumber, string $carrier)
    {
        $this->trackingNumber = $trackingNumber;
        $this->carrier = $carrier;
    }

    public function getTrackingNumber(): string
    {
        return $this->trackingNumber;
    }

    public function getCarrier(): string
    {
        return $this->carrier;
    }
}
