<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CreatePickupOrderResponse
{
    /**
     * @var string
     */
    private $id;

    /**
     * @var CarrierReference
     */
    private $carrierReference;

    /**
     * @var \DateTimeImmutable
     */
    private $createdTime;

    /**
     * @var \DateTimeImmutable
     */
    private $lastModifiedTime;

    public function __construct(string $id, CarrierReference $carrierReference, \DateTimeImmutable $createdTime, \DateTimeImmutable $lastModifiedTime)
    {
        $this->id = $id;
        $this->carrierReference = $carrierReference;
        $this->createdTime = $createdTime;
        $this->lastModifiedTime = $lastModifiedTime;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getCarrierReference(): CarrierReference
    {
        return $this->carrierReference;
    }

    public function getCreatedTime(): \DateTimeImmutable
    {
        return $this->createdTime;
    }

    public function getLastModifiedTime(): \DateTimeImmutable
    {
        return $this->lastModifiedTime;
    }
}
