<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CutoffTimeResponse
{
    /**
     * @var string
     */
    private $postalCode;

    /**
     * @var \DateTimeImmutable
     */
    private $cutoffTime;

    public function __construct(string $postalCode, \DateTimeImmutable $cutoffTime)
    {
        $this->postalCode = $postalCode;
        $this->cutoffTime = $cutoffTime;
    }

    public function getPostalCode(): string
    {
        return $this->postalCode;
    }

    public function getCutoffTime(): \DateTimeImmutable
    {
        return $this->cutoffTime;
    }
}
