<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Pickup\Response;

use InPost\International\Api\ListTrait;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PickupOrderList
{
    use ListTrait;

    /**
     * @var PickupOrder[]
     */
    private $items;

    /**
     * @param PickupOrder[] $items
     */
    public function __construct(array $items, int $count, int $page, int $perPage, int $totalPages)
    {
        $this->items = $items;
        $this->count = $count;
        $this->page = $page;
        $this->perPage = $perPage;
        $this->totalPages = $totalPages;
    }

    /**
     * @return PickupOrder[]
     */
    public function getItems(): array
    {
        return $this->items;
    }
}
