<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Point\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class DailyHours
{
    /**
     * @var TimeRange[]|null
     */
    private $monday;

    /**
     * @var TimeRange[]|null
     */
    private $tuesday;

    /**
     * @var TimeRange[]|null
     */
    private $wednesday;

    /**
     * @var TimeRange[]|null
     */
    private $thursday;

    /**
     * @var TimeRange[]|null
     */
    private $friday;

    /**
     * @var TimeRange[]|null
     */
    private $saturday;

    /**
     * @var TimeRange[]|null
     */
    private $sunday;

    /**
     * @param TimeRange[]|null $monday
     * @param TimeRange[]|null $tuesday
     * @param TimeRange[]|null $wednesday
     * @param TimeRange[]|null $thursday
     * @param TimeRange[]|null $friday
     * @param TimeRange[]|null $saturday
     * @param TimeRange[]|null $sunday
     */
    public function __construct(?array $monday, ?array $tuesday, ?array $wednesday, ?array $thursday, ?array $friday, ?array $saturday, ?array $sunday)
    {
        $this->monday = $monday;
        $this->tuesday = $tuesday;
        $this->wednesday = $wednesday;
        $this->thursday = $thursday;
        $this->friday = $friday;
        $this->saturday = $saturday;
        $this->sunday = $sunday;
    }

    /**
     * @return TimeRange[]|null
     */
    public function getMonday(): ?array
    {
        return $this->monday;
    }

    /**
     * @return TimeRange[]|null
     */
    public function getTuesday(): ?array
    {
        return $this->tuesday;
    }

    /**
     * @return TimeRange[]|null
     */
    public function getWednesday(): ?array
    {
        return $this->wednesday;
    }

    /**
     * @return TimeRange[]|null
     */
    public function getThursday(): ?array
    {
        return $this->thursday;
    }

    /**
     * @return TimeRange[]|null
     */
    public function getFriday(): ?array
    {
        return $this->friday;
    }

    /**
     * @return TimeRange[]|null
     */
    public function getSaturday(): ?array
    {
        return $this->saturday;
    }

    /**
     * @return TimeRange[]|null
     */
    public function getSunday(): ?array
    {
        return $this->sunday;
    }
}
