<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Point\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class OperatingHours
{
    /**
     * @var DailyHours|null
     */
    private $customerHours;

    public function __construct(DailyHours $customer = null)
    {
        $this->customerHours = $customer;
    }

    public function getCustomerHours(): ?DailyHours
    {
        return $this->customerHours;
    }
}
