<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Point\Model;

use InPost\International\Delivery\Point\PointInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Point implements PointInterface
{
    use PointTrait;

    /**
     * @var int[]|null
     */
    private $guaranteedLockerTemperatures;

    /**
     * @param string[] $capabilities
     * @param int[]|null $guaranteedLockerTemperatures
     */
    public function __construct(string $id, string $type, string $country, string $locationType, string $imageUrl, Coordinates $coordinates, bool $location247, array $capabilities, Address $address, TranslatedObject $description, TranslatedObject $description2, TranslatedObject $description3, OperatingHours $operatingHours, ?array $guaranteedLockerTemperatures = [])
    {
        $this->id = $id;
        $this->type = $type;
        $this->country = $country;
        $this->locationType = $locationType;
        $this->imageUrl = $imageUrl;
        $this->coordinates = $coordinates;
        $this->location247 = $location247;
        $this->capabilities = $capabilities;
        $this->address = $address;
        $this->description = $description;
        $this->description2 = $description2;
        $this->description3 = $description3;
        $this->operatingHours = $operatingHours;
        $this->guaranteedLockerTemperatures = $guaranteedLockerTemperatures;
    }

    /**
     * @return int[]
     */
    public function getGuaranteedLockerTemperatures(): ?array
    {
        return $this->guaranteedLockerTemperatures;
    }
}
