<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Point\Model;

use InPost\International\Enum\StringEnum;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method static self ParcelCollect()
 * @method static self ParcelSend()
 * @method static self CooledDeposit()
 */
final class PointCapability extends StringEnum
{
    private const PARCEL_COLLECT = 'PARCEL_COLLECT';
    private const PARCEL_SEND = 'PARCEL_SEND';
    private const COOLED_DEPOSIT = 'COOLED_DEPOSIT';
}
