<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Point\Model;

use InPost\International\Api\ListTrait;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PointList
{
    use ListTrait;

    /**
     * @var Point[]
     */
    private $items;

    /**
     * @param Point[] $items
     */
    public function __construct(array $items, int $count, int $page, int $perPage, int $totalPages)
    {
        $this->items = $items;
        $this->count = $count;
        $this->page = $page;
        $this->perPage = $perPage;
        $this->totalPages = $totalPages;
    }

    /**
     * @return Point[]
     */
    public function getItems(): array
    {
        return $this->items;
    }
}
