<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Point\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @internal
 */
trait PointTrait
{
    /**
     * @var string
     */
    private $id;

    /**
     * @var string
     */
    private $type;

    /**
     * @var string
     */
    private $country;

    /**
     * @var string
     */
    private $locationType;

    /**
     * @var string
     */
    private $imageUrl;

    /**
     * @var Coordinates
     */
    private $coordinates;

    /**
     * @var bool
     */
    private $location247;

    /**
     * @var string[]
     */
    private $capabilities;

    /**
     * @var Address
     */
    private $address;

    /**
     * @var TranslatedObject
     */
    private $description;

    /**
     * @var TranslatedObject
     */
    private $description2;

    /**
     * @var TranslatedObject
     */
    private $description3;

    /**
     * @var OperatingHours
     */
    private $operatingHours;

    public function getId(): string
    {
        return $this->id;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getCountry(): string
    {
        return $this->country;
    }

    public function getLocationType(): string
    {
        return $this->locationType;
    }

    public function getImageUrl(): string
    {
        return $this->imageUrl;
    }

    public function getCoordinates(): Coordinates
    {
        return $this->coordinates;
    }

    public function isLocation247(): bool
    {
        return $this->location247;
    }

    /**
     * @return string[]
     */
    public function getCapabilities(): array
    {
        return $this->capabilities;
    }

    public function hasCapability(PointCapability $capability): bool
    {
        return in_array($capability->value, $this->capabilities, true);
    }

    public function getAddress(): Address
    {
        return $this->address;
    }

    public function getDescription(): TranslatedObject
    {
        return $this->description;
    }

    public function getDescription2(): TranslatedObject
    {
        return $this->description2;
    }

    public function getDescription3(): TranslatedObject
    {
        return $this->description3;
    }

    public function getOperatingHours(): OperatingHours
    {
        return $this->operatingHours;
    }
}
