<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Point\Model;

use InPost\International\Enum\StringEnum;
use InPost\International\Translation\TranslatableInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method static self AutomaticParcelMachine()
 * @method static self PickUpDropOff()
 */
final class PointType extends StringEnum implements TranslatableInterface
{
    private const AUTOMATIC_PARCEL_MACHINE = 'APM';
    private const PICK_UP_DROP_OFF = 'PUDO';

    public function trans(TranslatorInterface $translator, string $locale = null): string
    {
        switch ($this) {
            case self::AutomaticParcelMachine():
                return $translator->trans('Parcel Locker', [], 'Modules.Inpostinternational.Point', $locale);
            case self::PickUpDropOff():
                return $translator->trans('ParcelPoint', [], 'Modules.Inpostinternational.Point', $locale);
            default:
                return $this->name;
        }
    }
}
