<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Point\Model;

use InPost\International\Delivery\Point\RelativePointInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class RelativePoint implements RelativePointInterface
{
    use PointTrait;

    /**
     * @var int
     */
    private $distance;

    /**
     * @param string[] $capabilities
     */
    public function __construct(string $id, string $type, string $country, string $locationType, string $imageUrl, Coordinates $coordinates, bool $location247, array $capabilities, Address $address, TranslatedObject $description, TranslatedObject $description2, TranslatedObject $description3, OperatingHours $operatingHours, int $distance)
    {
        $this->id = $id;
        $this->type = $type;
        $this->country = $country;
        $this->locationType = $locationType;
        $this->imageUrl = $imageUrl;
        $this->coordinates = $coordinates;
        $this->location247 = $location247;
        $this->capabilities = $capabilities;
        $this->address = $address;
        $this->description = $description;
        $this->description2 = $description2;
        $this->description3 = $description3;
        $this->operatingHours = $operatingHours;
        $this->distance = $distance;
    }

    public function getDistance(): int
    {
        return $this->distance;
    }
}
