<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Point\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class TranslatedObject
{
    /**
     * @var string|null
     */
    private $content;

    /**
     * @var string[]
     */
    private $translations;

    /**
     * @param array<string, string> $translations
     */
    public function __construct(?string $content, array $translations = [])
    {
        $this->content = $content;
        $this->translations = $translations;
    }

    public function getContent(): ?string
    {
        return $this->content;
    }

    /**
     * @return array<string, string>
     */
    public function getTranslations(): array
    {
        return $this->translations;
    }

    public function getTranslation(string $language): ?string
    {
        return $this->translations[$language] ?? $this->content;
    }
}
