<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Point;

use InPost\International\Api\Point\Exception\PostCodeNotFoundException;
use InPost\International\Api\Point\Model\Point;
use InPost\International\Api\Point\Model\PointList;
use InPost\International\Api\Point\Model\RelativePointList;
use InPost\International\Api\Point\Request\PointsRequest;
use InPost\International\Api\Point\Request\PointsSearchByLocationRequest;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface PointsApiClientInterface
{
    public const SCOPE_POINTS_READ = 'api:points:read';

    /**
     * Get a list of points based on provided search criteria
     */
    public function getPoints(PointsRequest $request): PointList;

    /**
     * Get a specific point by its ID
     */
    public function getPointById(string $id): Point;

    /**
     * Get points by geographic location
     *
     * @throws PostCodeNotFoundException
     */
    public function getPointsByLocation(PointsSearchByLocationRequest $request): RelativePointList;
}
