<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Model\Destination;

use InPost\International\Country;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class DestinationPoint
{
    /**
     * @var Country
     */
    private $countryCode;

    /**
     * @var string
     */
    private $pointName;

    public function __construct(Country $countryCode, string $pointName)
    {
        $this->countryCode = $countryCode;
        $this->pointName = $pointName;
    }

    public function getCountryCode(): Country
    {
        return $this->countryCode;
    }

    public function getPointName(): string
    {
        return $this->pointName;
    }
}
