<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Model\Origin;

use InPost\International\Country;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class OriginPoint
{
    /**
     * @var Country
     */
    private $countryCode;

    /**
     * @var PointShippingMethod[]
     */
    private $shippingMethods;

    /**
     * @param PointShippingMethod[] $shippingMethods
     */
    public function __construct(Country $countryCode, array $shippingMethods)
    {
        $this->countryCode = $countryCode;
        $this->shippingMethods = $shippingMethods;
    }

    public function getCountryCode(): Country
    {
        return $this->countryCode;
    }

    /**
     * @return PointShippingMethod[]
     */
    public function getShippingMethods(): array
    {
        return $this->shippingMethods;
    }
}
