<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Model\Origin;

use InPost\International\Enum\StringEnum;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method static self AutomaticParcelMachine()
 * @method static self PickUpDropOff()
 * @method static self Hub()
 */
final class PointShippingMethod extends StringEnum
{
    private const AUTOMATIC_PARCEL_MACHINE = 'APM';
    private const PICK_UP_DROP_OFF = 'PUDO';
    private const HUB = 'HUB';
}
