<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Model;

use InPost\International\Api\Shipment\Model\Parcel\Dimensions;
use InPost\International\Api\Shipment\Model\Parcel\ParcelLabel;
use InPost\International\Api\Shipment\Model\Parcel\ParcelType;
use InPost\International\Api\Shipment\Model\Parcel\Weight;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Parcel
{
    /**
     * @var ParcelType
     */
    private $type;

    /**
     * @var Dimensions
     */
    private $dimensions;

    /**
     * @var Weight
     */
    private $weight;

    /**
     * @var ParcelLabel|null
     */
    private $label;

    public function __construct(ParcelType $type, Dimensions $dimensions, Weight $weight, ParcelLabel $label = null)
    {
        $this->type = $type;
        $this->dimensions = $dimensions;
        $this->weight = $weight;
        $this->label = $label;
    }

    public function getType(): ParcelType
    {
        return $this->type;
    }

    public function getDimensions(): Dimensions
    {
        return $this->dimensions;
    }

    public function getWeight(): Weight
    {
        return $this->weight;
    }

    public function getLabel(): ?ParcelLabel
    {
        return $this->label;
    }
}
