<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Model\Parcel;

use InPost\International\Enum\StringEnum;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method static self Millimeter()
 * @method static self Centimeter()
 * @method static self Meter()
 */
final class DimensionUnit extends StringEnum
{
    private const MILLIMETER = 'MM';
    private const CENTIMETER = 'CM';
    private const METER = 'M';

    public static function getDefault(): self
    {
        return self::Centimeter();
    }

    public function getSymbol(): string
    {
        return strtolower($this->value);
    }

    public function convert(float $length, self $toUnit): float
    {
        if ($this === $toUnit) {
            return $length;
        }

        return $length * $this->getMultiplier() / $toUnit->getMultiplier();
    }

    public function getMultiplier(): float
    {
        switch ($this) {
            case self::Millimeter():
                return 0.001;
            case self::Centimeter():
                return 0.01;
            case self::Meter():
                return 1.;
            default:
                throw new \LogicException('Not implemented');
        }
    }
}
