<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Model\Parcel;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ParcelLabel implements \JsonSerializable, \Stringable
{
    /**
     * @var string|null
     */
    private $comment;

    /**
     * @var string|null
     */
    private $barcode;

    private function __construct()
    {
    }

    public static function comment(string $comment): self
    {
        $label = new self();
        $label->comment = $comment;

        return $label;
    }

    public static function barcode(string $barcode): self
    {
        $label = new self();
        $label->barcode = $barcode;

        return $label;
    }

    public function getComment(): ?string
    {
        return $this->comment;
    }

    public function getBarcode(): ?string
    {
        return $this->barcode;
    }

    public function jsonSerialize(): array
    {
        return array_filter(get_object_vars($this));
    }

    public function __toString(): string
    {
        return $this->comment ?? $this->barcode;
    }
}
